<?php

/*

	Create the link for moving from one page to another

*/



function getPagingLink($totalResults, $pageNumber, $itemPerPage = 10, $strGet = '')

{

    $flag=$_REQUEST['flag'];

	

	

	$pagingLink    = '';

	$totalPages    = ceil($totalResults / $itemPerPage);

	

	// how many link pages to show

	$numLinks      = 10;



	// create the paging links only if we have more than one page of results

	if ($totalPages > 1) {

		$self = 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] ;



		// print 'previous' link only if we're not

		// on page one

		if ($pageNumber > 1) {

			$page = $pageNumber - 1;

			if ($page > 1) {

				$prev = " <a href=\"$self?pageNum=$page&$strGet&flag=$flag\" class=link>[Prev]</a> ";

			} else {

				$prev = " <a href=\"$self?$strGet&flag=$flag\"  class=link>[Prev]</a> ";

			}	

				

			$first = " <a href=\"$self?$strGet&flag=$flag\"  class=link>[First]</a> ";

		} else {

			$prev  = ''; // we're on page one, don't show 'previous' link

			$first = ''; // nor 'first page' link

		}

	

		// print 'next' link only if we're not

		// on the last page

		if ($pageNumber < $totalPages) {

			$page = $pageNumber + 1;

			$next = "<a href=\"$self?pageNum=$page&$strGet&flag=$flag\"  class=link>[Next]</a> </font>";

			$last = " <a href=\"$self?pageNum=$totalPages&$strGet&flag=$flag\"  class=link>[Last]</a> ";

		} else {

			$next = ''; // we're on the last page, don't show 'next' link

			$last = ''; // nor 'last page' link

		}



		$start = $pageNumber - ($pageNumber % $numLinks) + 1;

		$end   = $start + $numLinks - 1;		

		

		$end   = min($totalPages, $end);

		

		$pagingLink = array();

		for($page = $start; $page <= $end; $page++)	{

			if ($page == $pageNumber) {

				$pagingLink[] = " $page ";  

			} else {

				if ($page == 1) {

					$pagingLink[] = " <a href=\"$self?$strGet&flag=$flag\"  class=link>$page</a> ";

				} else {	

					$pagingLink[] = " <a href=\"$self?pageNum=$page&$strGet&flag=$flag\"  class=link>$page</a> ";

				}	

			} 

	

		}

		

		$pagingLink = implode(' | ', $pagingLink);

		

		// return the page navigation link

		$pagingLink = $first . $prev . $pagingLink . $next . $last;

	}

	

	return $pagingLink;

}

